# tampline 调用

我们需要编写一个函数，对浮点数进行sigmod计算，即 `f(x)=1/(1+e^(-x))`，下列函数实现正确的是：

## 答案

```java
import math.Math;

public class Util{
    public float sigmod(float x){
        return 1/(1+Math.exp(-x));
    }
}
```

## 选项

### 没有 return

```java
import math.Math;

public class Util{
    public float sigmod(float x){
        1/(1+Math.exp(-x));
    }
}
```

### 错误的结果返回方式

```java
import math.Math;

public class Util{
    public void sigmod(float x, float result){
        result = 1/(1+Math.exp(-x));
    }
}
```

### 结构定义错误

```java
import math.Math;

public class Util{
    public sigmod(float x) -> float{
        return 1/(1+Math.exp(-x));
    }
}
```

### 结构定义错误

```java
import math.Math;

public class Util{
    public sigmod(float x):float = {
        return 1/(1+Math.exp(-x));
    }
}
```

### 结构定义错误

```java
import math.Math;

public class Util{
    public sigmod(float x) returns float {
        return 1/(1+Math.exp(-x));
    }
}
```

### 结构定义错误

```java
import math.Math;

public class Util{
    public sigmod(float x):float {
        return 1/(1+Math.exp(-x));
    }
}
```

