# skill_tree_java

## 初始化

```
pip install -r requirement.txt
```


## 目录结构说明

* 技能树`骨架文件`：
    * 位置：`data/tree.json` 
    * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
    * 位置：`data/config.json`
    * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
    * 位置：`data/xxx`，例如: `data/1.Java初阶`
    * 说明：
        * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述`
    * 说明：
        * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
    * 位置：`data/xxx/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述/1.什么是Java`
    * 说明：
        * 每个技能树的每章有 `n` 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json`
            * 其中 `node_id` 字段是生成的，请勿编辑
            * 其中 `keywords` 可配置关键字字段
            * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
            * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述


## `知识节点` 子树信息结构

例如 `data/1.Java初阶/1.Java概述/1.什么是Java/config.json` 里配置对该知识节点子树信息结构：
```json
{
    // ...

    "children": [
        // TODO ...
    ],
}
```



## `知识节点` 的导出习题编辑

例如 `data/1.Java初阶/1.Java概述/1.什么是Java/config.json` 里配置对该知识节点导出的习题

```json
{
    // ...
    "export": [
        // TODO ...
    ]
}
```

格式说明：
* `file`: 指定该目录下的习题源文件
* `variants`： 指定习题同名的json选项配置文件，参考下一节
* `depends`: 如果习题依赖同目录下的其他习题源代码，则在此字段里配置依赖的其他习题源文件名

## `知识节点` 的导出习题选项配置编辑

首先，在知识节点下增加一个习题代码，例如在 `data/1.Java初阶/1.Java概述/1.什么是Java` 下增加一个`HelloWorld.java`代码：

```java
public class App {
    public static void main(String[] args){
        System.out.println("Hello world!")
    }
}
```

其次，增加一个同名的选项配置文件`HelloWorld.json`，目前有三种配置规则

### 单行替换规则

* 配置由`one_line`字段指定的单行替换字典
* 格式是：`"<源字符串>"`: [`"<替换字符串A>"`, `<替换字符串B>`,...],
    * 其中每个 `"<源字符串>"` `/` `"<替换字符串A>"` 被生成为是一个替换选项
    * 指定的配置应该能至少生成 `3+` 个替换选项

```json
{
    "one_line": {
        "println": ["printf", "print", "fprint"]
    }
}
```

上面的替换规则会将代码替换成 3 个变种的代码：

```java
public class App {
    public static void main(String[] args){
        System.out.print("Hello world!")
    }
}
```

```java
public class App {
    public static void main(String[] args){
        System.out.printf("Hello world!")
    }
}

```

```java
public class App {
    public static void main(String[] args){
        System.out.sprint("Hello world!")
    }
}
```

这些变种代码将会作为技能树该知识点该代码选择题的选项。

### 多行替换规则

* 配置由`multiline`字段指定的多行替换数组
* 数组的每个元素是一组替换规则，会整组被替换

例如：

```json
{
    "mulitiline": [{
        "public class": "public interface",
        "main(": "Main("
    },
    { 
        "public class": "interface",
        "void main": "int main"
    },
    {
        "public static void main": "public void main"
    }]
```

上面的替换规则会将代码替换成 3 个变种的代码：

```java
public interface App {
    public static void Main(String[] args){
        System.out.println("Hello world!")
    }
}
```

```java
public interface App {
    public static int main(String[] args){
        System.out.println("Hello world!")
    }
}

```

```java
public class App {
    public void main(String[] args){
        System.out.print("Hello world!")
    }
}
```

这些变种代码将会作为技能树该知识点该代码选择题的选项。


### 预制的替换规则

 * 配置由 `prepared` 字段制定的预制文件数组
 * 数组每一个元素是一个预制的代码文件的路径文件名

例如：

```json
{
    "prepared": [
        "HelloWord.1.java",
        "HelloWord.2.java",
        "HelloWord.3.java"]
}
```

同样，该配置将支持将源代码生成3个变种代码

```java
// HelloWord.1.java
public interface App {
    default void Main(String[] args){
        System.out.println("Hello world!")
    }
}
```

```java
public interface App {
    public static void main(String[] args){
        System.out.println("Hello world!")
    }
}

```

```java
class App {
    void main(String[] args){
        System.out.print("Hello world!")
    }
}
```



## 技能树合成

在`src`目录下执行 `python main.py -a tree` 会合成技能树文件，合成的技能树文件: `data/tree.json`
* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
