# Optional 应用

现有一个 `Optional<String> opt` 对象，下列代码中，哪一个操作有可能因为opt里携带了空值而抛出异常？

## 答案

```java
var item = opt.get();
```

## 选项

### A

```java
return opt.flatMap(s->post(s));
```

### B

```java
return opt.map(s->s.split(","));
```

### C

```java
var item = opt.orElse("nothing");
```

### D

```java
if(opt.isPresent()){
    return opt.get();
} else {
    return findNext();
}
```

### E

```java
if(opt.isEmpty()){
    return 0;
} else {
    rank(opt.get())
}
```
