# 函数的重写

我们需要编写一个函数`gaussian`，使其生成服从正态分布$N\left(\mu, \sigma^2\right)$的随机数。其中$\mu$为数学期望，$\sigma^2$为方差，关于正态分布可以参考[百度百科](https://baike.baidu.com/item/%E6%AD%A3%E6%80%81%E5%88%86%E5%B8%83/829892)。现已有函数如下：

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();
    private static double gaussian(double mu, double sigma2) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

但上述函数仍然需要我们传入$\mu$和$\sigma^2$的值，这会在实际使用这一函数的时候带来麻烦。

为了解决这一问题，我们需要对函数进行重写，使之能快速产生：

1. 数学期望$\mu = 0$的正态分布随机数
2. 服从标准正态分布（$\mu = 0$，$\sigma^2 = 1$）的随机数

以达成简化`gaussian`函数使用的效果，以下选项正确的是？

## 答案

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();

    private static double gaussian() {
        return gaussian(0, 1);
    }

    private static double gaussian(double sigma2) {
        return gaussian(0, sigma2);
    }

    private static double gaussian(double mu, double sigma2) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

## 选项

### Python味的默认值，然而Java并不支持

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();
    private static double gaussian(double mu = 0, double sigma2 = 1) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

### 用法正确，但不符合题目要求

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();

    private static double gaussian() {
        return gaussian(0, 1);
    }

    private static double gaussian(double mu) {
        return gaussian(mu, 1);
    }

    private static double gaussian(double mu, double sigma2) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

### Python味的默认值，Java并不支持，就一个也不成

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();

    private static double gaussian() {
        return gaussian(0, 1);
    }

    private static double gaussian(double mu, double sigma2 = 1) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

### 函数重写时的标识符必须可区分

```java
import java.util.Random;

public class TestMain {
    private static final Random random = new Random();

    private static double gaussian() {
        return gaussian(0, 1);
    }

    private static double gaussian(double sigma2) {
        return gaussian(0, sigma2);
    }

    private static double gaussian(double mu, double sigma2) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }

    private static double gaussian(double sigma2, double mu) {
        return Math.sqrt(sigma2) * random.nextGaussian() + mu;
    }
}
```

