# using 模式

已知我们有一个特殊的文件类型 PopFile，这个类型的对象方法 read() 可以返回字符串
数据，当读取到末尾的时候，会抛出 Eof 异常，我们希望先通过 PopFile.open(path)
新建一个对象，并从这样一个 PopFile 对象中读取最多一百个文本数据，然后调用 close 
方法关闭它。返回字符串列表`List<String>`。但是这个对象中的数据可能不足一百个。
此时我们需要在末尾添加一项 `[stop]`。

如果我们想要用一下 `try using` 形式可靠的关闭 PopFile，需要满足什么条件？

```java
public class App{
    public List<String> Top100(String path){
        List<String> result = new ArrayList();
        try(PopFile popFile = PopFile.open(path)){
            for(int i=0; i<100; i++){
                result.add(popFile.read());
            }
        } catch(EofException eof){
            result.add("[stop]");
        } 
        return reseult;
    }
}
```

## 答案

实现 `java.io.Closeable` 接口。

## 选项

### A

实现 `void close()` 方法。

### B

实现  `boolean close()` 方法.

### C

实现 `java.io.AutoClosable` 接口。

### D

实现 `finally()` 方法。

### E

实现 `exit()` 方法。