# skill_tree_java

`Java技能树`是[技能森林](https://gitcode.net/csdn/skill_tree)的一部分。

为了操作方便，在仓库中有一组微型的 Python 工具脚本，用于加工和维护技能树，一般情况下不用关注。对于项目贡献者，
主要维护的是技能树的目录结构和相关习题

## 环境准备

技能树仓库提供了辅助的工具脚本和 git hook 程序，在开始编辑工作之前，需要初始化环境依赖，我们推荐使用 python 3.8 或更高版本的 python。

首先，请确认系统中已经安装 python 和 git，然后执行下列命令克隆仓库：

```shell
git clone git@codechina.csdn.net:csdn/skill_tree_java.git
```

然后进入 skill_tree_java 目录，执行下列命令安装依赖：

```shell
pip install -r requirements.txt
```

然后执行下列命令安装钩子：

```shell
pre-commit install
```

## 目录结构说明

* 技能树`骨架文件`：
    * 位置：`data/tree.json` 
    * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
    * 位置：`data/config.json`
    * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
    * 位置：`data/xxx`，例如: `data/1.Java初阶`
    * 说明：
        * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述`
    * 说明：
        * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
    * 位置：`data/xxx/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述/1.什么是Java`
    * 说明：
        * 每个技能树的每章有 `n` 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json`
            * 其中 `node_id` 字段是生成的，请勿编辑
            * 其中 `keywords` 可配置关键字字段
            * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
            * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述


## `知识节点` 子树信息结构

例如 `data/1.Java初阶/1.Java概述/1.什么是Java/config.json` 里配置对该知识节点子树信息结构：
```json
{
    // ...

    "children": [
        // TODO ...
    ],
}
```

## 习题编辑

编辑者需要关注两个重点问题
- 根据需要编辑技能树的目录，每个目录应该由`序号.标题`组成，序号的数字不需要精确的保持连续，只要是整数即可，在提交
  前执行 `python main.py`，该脚本会辅助整理目录序号
- 在知识点的目录下编写习题，目前推荐使用 markdown 格式，我们仅就这个格式的习题编辑进行介绍

如前文内容，我们在知识节点下增加习题 `HelloWord`的定义文件，即在`data/1.Java初阶/1.Java概述/1.什么是Java` 
目录新建一个名为 `HelloWorld.md` 的文本文件，并编辑为：

````markdown
# Hello World

以下 `Hello World` 程序中，能够正确输出内容的是：

## 答案

```java

public class App {
    public static void main(String[] args){
        System.out.println("Hello World");
    }
}
```

## 选项

### 不必要的返回值

```java

public class App {
    public int main(){
        System.out.printf("Hello World");
        return 0;
    }
}
```

### 没有引用 System.out

```java

public class App {
    public static void main(String[] args){
        println("Hello World");
    }
}
```

### 混合了 c 代码

```java
import stdout

public class App {
    public int main(){
        print("Hello World\n");
        return 0;
    }
}

```

````

这是一个最基本的习题结构，它包含标题、答案、选项，注意这几个一级和二级标题必须填写正确，解释器会读取这几个标题。而选项的标题会被直接忽略掉，在
最终生成的习题中不包含选项的三级标题，所以这个标题可以用来标注一些编辑信息，例如“此选项没有关闭文件连接”，“类型错误”等等。

### 增强信息

为了编写习题和生成 notebook 的需要，markdown 解释器支持两种模板能力，如果我们在答案之前，有一个名为 aop 的二级标题：

````markdown

## aop

### before

```java
System.out.print("hello world");
```

### after

```java
App.main(new String[]{});
```
````

那么在创建notebook的时候，before 会插入到源代码前一个单元，after 则会插入到源代码后。aop 章节可以只包含 before 或 after 中的某一个，也可以两个都有。

另一些情况下，我们可能需要把各个选项中重复的代码提取出来，建立一个模板，此时可以在答案之前建立一个名为 template 的二级标题，例如：

````markdwon

## template

```java
public class App {
    public static void main(String[] args){
        // 下面的 code 占位符会被替换成答案和选项代码
        $code
    }
}
```

````

注意这里的代码中，有一个 `$code` 占位符，它在管道程序处理过程中，会替换成答案和个选项内容中的代码。

## 技能树合成

在根目录下执行 `python main.py` 会合成技能树文件，合成的技能树文件为: `data/tree.json`
* 合成过程中，会检查章节目录下是否有 `config.json` 文件，如果没有，会自动生成，需要注意的是，这时 config.json是不完
  整的，没有 keywords 信息
* 每个知识点目录（即技能树最末端的叶子节点）的 config.json ，需要设定关键字，如果 `config.json` 的 keywords 为空，执行
  main.py 会提示错误并中途退出，执行`git commit`时，commit 钩子也会拒绝提交
* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会修复目录的序号，保持每一个章节目录的子目录总是从 1 开始的整数序列
* 合成过程中，会自动检查每个知识点目录下的 markdown 文件，是否有对应的配置信息，如果不存在则生成
    * 生成的习题配置信息中，author是根据git环境信息填写的，如果这个作者名不是您的csdn账户名，您可以手工编辑修改
    * config.json 的 export 字段定义了同一个知识点下习题的顺序，如果需要定义不同的顺序，您可以手工调整
    * 技能树仓库钩子和辅助工具都会检查信息完整性，并尝试做必要的修补，因此可能在提交时发现有一些新文件
      生成，请在后续的提交中将它们也发送到服务器仓库

