# Single Abstract Method

下面哪一个类型定义，在构造其对象时，可以简化为 lambda？

## 答案

```java
public interface Parsec<E, T> {
    default T ask(State<E> state) {
        try {
            return new Success(this.parse(state));
        } catch (Exception error){
            return new Failure(error);
        }
    }
    
    T parse(State<E> state); 
} 
```

## 选项

### SAM 需要 interface

```java
public abstract class Element {
    String read();
    void write(String content);
}
```

### 有两个未定义方法

```java
public interface Element {
    String read();
    void write(String content);
}
```

### 没有抽象方法，无法按 SAM 处理

```java
public class Cell {
    String content;
    public Cell(String content){
        this.content = content;
    }
    public String text() {
        return content;
    }
    public String text(String content){
        this.content = content;
    }
}
```
