# 求和

下面代码对整数流求和，其中有错的是

## 答案

```java
Stream<Integer> stream = IntStream.range(0,100).boxed();
return stream.mapToInt(x -> x);
```

## 选项

### 标准库方法

```java
Stream<Integer> stream = IntStream.range(0,100).boxed();
return stream.sum();
```

### 显式调用 simmingInt 方法，可以定义一些复杂的处理逻辑

```java
var collector = Collectors.<Integer>summingInt(x->x);
return stream.collect(collector);
```

### 也可以封装到一个朴素的方法中，作为隐式简写

```java
var collector = Collectors.<Integer>summingInt(this::identity);
return stream.collect(collector);
```

### 也可以封装到一个朴素的方法中，作为隐式简写

```java
var collector = Collectors.<Integer>summingInt(App::identity);
return stream.collect(collector);
```