# 过滤

Stream API支持 filter 方法，接受一段过滤代码，使得调用者可以传入过滤规则，返回过滤后的新的 Stream，那么下列调用代码不正确的是：

## 答案

```java
    IntStream stream=IntStream.range(0,100);
        return stream.filter(x%2==0);
```

## 选项

### 标准的 lambda 调用

```java
    IntStream stream=IntStream.range(0,100);
    return stream.filter(x->x%2==0);
```

### lambda 的完整形式

```java
    IntStream stream=IntStream.range(0,100);
        return stream.filter(x->{
        return x%2==0;
    });
```

### 对象方法引用

```java
    IntStream stream=IntStream.range(0,100);
    return stream.filter(this::isEven);
```

### 类型方法引用

```java
    IntStream stream=IntStream.range(0,100);
    return stream.filter(App::isEven);
```

### 可以显式使用完整的函数对象定义

```java
    IntStream stream=IntStream.range(0,100);
    IntPredicate filter = new IntPredicate() {
            @Override
            public boolean test(int value) {
                    return value % 2 == 0;
            }
        };
    return stream.filter(filter);
```