# File Lock


使用多线程读写同一个文件，选出你认为最合理的一种读取方法：


## 答案

```java
public void readFile(String path) {
    RandomAccessFile file = null;
    FileLock lock = null;
    try {
        file = new RandomAccessFile(path, "rw");
        FileChannel fileChannel = file.getChannel();
        lock = fileChannel.lock();
        // read and write 
    } catch (IOException e) {
        System.out.println(e);
    } finally {
        if (lock != null) {
            try {
                lock.release();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file != null) {
            try {
                file.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
```

## 选项

### A

```java
public void readFile(String path) throws IOException {
    RandomAccessFile file = new RandomAccessFile(path, "rw");
    FileChannel fileChannel = file.getChannel();
    // read and write 
    file.close();
}
```

### B

```java

public void readFile(String path) throws IOException {
    RandomAccessFile file = new RandomAccessFile(path, "rw");
    FileChannel fileChannel = file.getChannel();
    FileLock lock = fileChannel.lock();
    // read and write 
    lock.release();
    file.close();
}
```

### C

```java
public void readFile(String path) {
    RandomAccessFile file = null;
    FileLock lock = null;
    try {
        file = new RandomAccessFile(path, "rw");
        FileChannel fileChannel = file.getChannel();
        lock = fileChannel.lock();
        // read and write 
    } catch (IOException e) {
        System.out.println(e);
    } finally {
        try {
            lock.release();
            file.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
```
