# skill_tree_java

## 目录结构说明

* 技能树`骨架文件`：
    * 位置：`data/tree.json` 
    * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
    * 位置：`data/config.json`
    * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
    * 位置：`data/xxx`，例如: `data/1.Java初阶`
    * 说明：
        * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述`
    * 说明：
        * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
    * 位置：`data/xxx/xxx/xxx`，例如：`data/1.Java初阶/1.Java概述/1.什么是Java`
    * 说明：
        * 每个技能树的每章有 `n` 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json`
            * 其中 `node_id` 字段是生成的，请勿编辑
            * 其中 `keywords` 可配置关键字字段
            * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
            * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述


## `知识节点` 子树信息结构

例如 `data/1.Java初阶/1.Java概述/1.什么是Java/config.json` 里配置对该知识节点子树信息结构：
```json
{
    // ...

    "children": [
        // TODO ...
    ],
}
```



## `知识节点` 的导出习题编辑

例如 `data/1.Java初阶/1.Java概述/1.什么是Java/config.json` 里配置对该知识节点导出的习题

```json
{
    // ...
    "export": [
        "HellowWorld.json"
    ]
}
```

在 export 字段中，我们列出习题定义 json ，下面我们了解如何编写习题。

## `知识节点` 的导出习题选项配置编辑

目前我们支持使用 markdown 语法直接编辑习题和各选项。

如前文内容，我们在知识节点下增加习题 `HelloWord`的定义文件，即在`data/1.Java初阶/1.Java概述/1.什么是Java` 目录增加一个`HelloWorld.json`文件：

```json
{
    "type": "code_options",
    "author": "刘鑫",
    "source": "HelloWorld.md",
    "notebook_enable": true
}
```
其中 type 字段目前都固定是 `code_options`，notebook_enable 字段决定这个习题是否生成对应的 notebook 。根据具体情况写好其它字段，注意这里 source 的文件名，我们指定了一个 markdwon 文件。现在我们新建一个 HelloWorld.md 并编辑为：

````markdown
# Hello World

以下 `Hello World` 程序中，能够正确输出内容的是：

## 答案

```java

public class App {
    public static void main(String[] args){
        System.out.println("Hello World");
    }
}
```

## 选项

### 不必要的返回值

```java

public class App {
    public int main(){
        System.out.printf("Hello World");
        return 0;
    }
}
```

### 没有引用 System.out

```java

public class App {
    public static void main(String[] args){
        println("Hello World");
    }
}
```

### 混合了 c 代码

```java
import stdout

public class App {
    public int main(){
        print("Hello World\n");
        return 0;
    }
}

```

````

这是一个最基本的习题结构，它包含标题、答案、选项，注意这几个一级和二级标题必须填写正确，解释器会读取这几个标题。而选项的标题会被直接忽略掉，在
最终生成的习题中不包含选项的三级标题，所以这个标题可以用来标注一些编辑信息，例如“此选项没有关闭文件连接”，“类型错误”等等。

### 增强信息

为了编写习题和生成 notebook 的需要，markdown 解释器支持两种模板能力，如果我们在答案之前，有一个名为 aop 的二级标题：

````markdown

## aop

### before

```java
System.out.print("hello world");
```

### after

```java
App.main(new String[]{});
```
````

那么在创建notebook的时候，before 会插入到源代码前一个单元，after 则会插入到源代码后。aop 章节可以只包含 before 或 after 中的某一个，也可以两个都有。

另一些情况下，我们可能需要把各个选项中重复的代码提取出来，建立一个模板，此时可以在答案之前建立一个名为 template 的二级标题，例如：

````markdwon

## template

```java
public class App {
    public static void main(String[] args){
        // 下面的 code 占位符会被替换成答案和选项代码
        $code
    }
}
```

````

注意这里的代码中，有一个 `$code` 占位符，它在管道程序处理过程中，会替换成答案和个选项内容中的代码。

## 技能树合成

在`src`目录下执行 `python main.py -a tree` 会合成技能树文件，合成的技能树文件: `data/tree.json`
* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
