# DynamicProxyTest


以下程序是关于动态代理的一个例子，1和2处填入正确的是：
```java

interface Person {
    void speak(String text);
}

public class DynamicProxyTest {
    public static void main(String[] args) {
        InvocationHandler handler = new InvocationHandler() {
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (method.getName().equals("speak")) {
                    System.out.println("准备");
                    System.out.println(args[0]);
                    System.out.println("结束");
                }
                return null;
            }
        };
        Person person = (Person) Proxy.newProxyInstance(
                1,
                2,
                handler);
        person.speak("你好，很高兴认识你。");
    }
}
```


## 答案

```
Person.class.getClassLoader()
new Class[] { Person.class }
```

## 选项

### A

```
Person.getClassLoader()
Person.class
```

### B

```
Person.class.getClassLoader()
Person.getClass()
```

### C

```
Person.getClassLoader()
new Class[] { Person.class }
```
