# Proxy


下列对http请求使用代理的方式正确的是：


## 答案

```
以上选择均正确
```

## 选项

### A

```java
// 在你发起Http请求之前设置代理属性
Properties prop = System.getProperties();
prop.setProperty("http.proxyHost",  proxyHost);
prop.setProperty("http.proxyPort",  proxyPort);
```

### B

```java
// 通过Proxy来配置代理信息
URL url = new URL("http://www.baidu.com");
Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)); 
URLConnection conn = url.openConnection(proxy);
```

### C

```java
// httpclient设置代理
HttpClient client = HttpClient.newBuilder()
                .version(HttpClient.Version.HTTP_2)
                .connectTimeout(Duration.ofSeconds(10))
                .proxy(ProxySelector.of(new InetSocketAddress(proxyHost, proxyHost)))
                .build();
```
