# 计数器

我们需要在工作线程中统计一个计数，这个计数是全局可见的，下面哪段代码有错？

## 答案

```java

public class Worker extends Thread {
    private static int count = 0;
    public static int getCount() {
        return count;
    }
    public static void increment() {
        count = count + 1;
    }
    
    @Override
    public void run() {
        //... do something
        increment();
    }
}
```

## 选项

### 内置并发对象

```java
import java.util.concurrent.atomic.AtomicInteger;

public class Worker extends Thread {
    public static final AtomicInteger counter = new AtomicInteger(0);
    
    @Override
    public void run() {
        //... do something
        counter.incrementAndGet();
    }
}
```

### 朴素的加锁方法

```java

public class Worker extends Thread {
    private static volatile int count = 0;
    public static int getCount() {
        return count;
    }
    public static synchronized void increment() {
        count = count + 1;
    }

    @Override
    public void run() {
        //... do something
        increment();
    }
}
```

### 朴素的锁机制

```java
public class Worker extends Thread {
    private static Lock lock = new ReentrantLock();
    private static Integer count = 0;
    public static int getCount() {
        return count;
    }
    public static void increment() {
        lock.lock();
        try {
            count = count + 1;
        } finally {
            lock.unlock();
        }
    }

    @Override
    public void run() {
        //... do something
        increment();
    }
}
```
