# 分组

已知类型

```java
public class Employee{
    int id;
    String name;
    String department;
}
```

将 `List<Employee> employee` 中的员工信息按部门分组，其中不正确的是：

## 答案

```java
// List<Employee> employee = ...;
Map<String, Object> result = employee.stream().collect(toMap(Employee::getDepartment, Function.identity()));
```

## 选项

### 标准方法

```java
// List<Employee> employee = ...;
Map<String, List<Employee>> result = employee.stream().collect(groupingBy(Employee::getDepartment));
```

### 朴素方法

```java
// List<Employee> employee = ...;
Map<String, List<Employee>> result = new HashMap<>();
for(var emp: employee){
    var list = result.getOrDefault(emp.department, new ArrayList<>());
    list.add(emp);
}
```

### 朴素方法

```java
Map<String, List<Employee>> result = new HashMap<>();
for(int index=0; index < employee.size(); index++){
    var emp = employee.get(index);
    var list = result.getOrDefault(emp.department, new ArrayList<>());
    list.add(emp);
}
```
