# 接口

关于接口，错误的选项是

## 答案

```java
public interface Named{
    Named(String value);
    String literal();
}
```

## 选项

### interface 可以有 default 实现

```java
public interface Parsec{
    Try<String> parse(State<String> state);

    default T ask(State<String> state) {
        var result = parse(state);
        if(result.isSuccess()){
            return result.get();
        } else {
            throw result.err();
        }
    }
}
```

### interface 可以有类型参数

```java
public interface Parsec<E, T>{
    Try<T> parse(State<E> state);

    default T ask(State<E> state) {
        var result = ask(state);
        if(result.isSuccess()){
            return result.get();
        } else {
            throw result.err();
        }
    }
}
```

### interface 可以实现

```java
public class One implements Parsec<String, String>{

    default T parse(State<String> state) {
        return state.next();
    }
}
```

### SAM

```java
public interface Parsec<E, T> {
    public Parsec<E, T> then(Parsec<E, T> psc) {
        return state -> {
            this.parse(state);
            return psc.parse(state)
        }
    }
}
```