# Future 

我们有如下代码：

```java
import java.util.concurrent.Executors;

ExecutorService pool = Executors.newCachedThreadPool();

var amount = 0.0f; 
List<Future<Float>> futures = //submit jobs into the pool for create futures list

for(var f: futures){
    amount += f.get();
}
//...
```

下面分析中，错误的是

## 答案

此代码中有并发冲突

## 选项

### A

如果future执行过程中有较多的阻塞或低速逻辑，有可能阻塞所有future。

### B

Future 对象的 get 方法有可能抛出异常。

### C

这段程序的执行时间取决于任务池的并行设置和最慢的future的执行时间。

### D

Future 可以不加修改运行在不同的 ExecutorService 实现上。