# junit

下列单元测试代码，会被忽略的是：

## 答案

```java

@Ignore
@Test
public void simpleCrlf() throws Throwable {
    State<Character> state = newState("\r\n");
    Parsec<Character, String> crlf = new Crlf();

    String re = crlf.parse(state);
    Assert.assertEquals(re, "\r\n");
}
```

## 选项

### A

```java
@Test
public void simpleCrlf() throws Throwable {
    State<Character> state = newState("\r\n");
    Parsec<Character, String> crlf = new Crlf();

    String re = crlf.parse(state);
    Assert.assertEquals(re, "\r\n");
}
```

### B

```java
@AfterClass
static public void close(){
    try {
        conn.close();
    } catch (SQLException e) {
        e.printStackTrace();
    }
}
```

### C

```java
@BeforeClass
static public void connect() {
    try {
        // create a connection to the database
        conn = DriverManager.getConnection(url);
        System.out.println("Connection to SQLite has been established.");
        conn.prepareStatement("create table test(id integer primary key autoincrement, content text)")
            .execute();
    } catch (SQLException e) {
        System.out.println(e.getMessage());
    }
}
```

### D

```java
    @Test
public void zooCleanTest(){
    Statement statement = delete().from(table);
    try{
        statement.execute(conn);
        Assert.assertTrue(true);
    } catch (SQLException|IllegalStateException e) {
        Assert.fail(e.getMessage());
    }
}
```