# Object Serializable


以下关于对象的序列化与反序列化程序中，正确的是：

## aop

### before

```java
//
```

## 答案

```java
import java.io.*;
import java.io.Serializable;

class Student implements Serializable {
    private String name;
    private String sex;
    private Integer age;

    public Student(String name, String sex, Integer age) {
        this.name = name;
        this.sex = sex;
        this.age = age;
    }

    @Override
    public String toString() {
        return "name:" + this.name + "," + "sex:" + this.sex + "," + "age:" + this.age;
    }
}

public class SerializableDemo {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        // 序列化
        Student student = new Student("小明", "男", 15);
        System.out.println(student);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("student"));
        oos.writeObject(student);
        oos.close();
        // 反序列化
        File file = new File("student");
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        Student student = (Student) ois.readObject();
        ois.close();
        System.out.println(student);
    }
}
```

## 选项

### A

```java
import java.io.*;

public class Student {
    private String name;
    private String sex;
    private Integer age;

    public Student(String name, String sex, Integer age) {
        this.name = name;
        this.sex = sex;
        this.age = age;
    }

    @Override
    public String toString() {
        return "name:" + this.name + "," + "sex:" + this.sex + "," + "age:" + this.age;
    }
}

public class SerializableDemo {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        // 序列化
        Student student = new Student("小明", "男", 15);
        System.out.println(student);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("student"));
        oos.writeObject(student);
        oos.close();
        // 反序列化
        File file = new File("student");
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        Student student = (Student) ois.readObject();
        ois.close();
        System.out.println(student);
    }
}
```

### B

```java
import java.io.*;
import java.io.Serializable;

public class Student implements Serializable {
    private String name;
    private String sex;
    private Integer age;

    public Student(String name, String sex, Integer age) {
        this.name = name;
        this.sex = sex;
        this.age = age;
    }

    @Override
    public String toString() {
        return "name:" + this.name + "," + "sex:" + this.sex + "," + "age:" + this.age;
    }
}

public class SerializableDemo {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        // 序列化
        Student student = new Student("小明", "男", 15);
        System.out.println(student);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("student"));
        oos.writeObject(student);
        oos.close();
        // 反序列化
        File file = new File("student");
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        Student student = ois.readObject();
        ois.close();
        System.out.println(student);
    }
}
```

### C

```java
import java.io.*;
import java.io.Serializable;

public class Student implements Serializable {
    private String name;
    private String sex;
    private Integer age;

    public Student(String name, String sex, Integer age) {
        this.name = name;
        this.sex = sex;
        this.age = age;
    }

    @Override
    public String toString() {
        return "name:" + this.name + "," + "sex:" + this.sex + "," + "age:" + this.age;
    }
}

public class SerializableDemo {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        // 序列化
        Student student = new Student("小明", "男", 15);
        System.out.println(student);
        ObjectOutputStream oos = new ObjectOutputStream(new FileInputStream("student"));
        oos.writeObject(student);
        oos.close();
        // 反序列化
        File file = new File("student");
        ObjectInputStream ois = new ObjectInputStream(new FileOutputStream(file));
        Student student = (Student) ois.readObject();
        ois.close();
        System.out.println(student);
    }
}
```

