# FileRead


以下 `FileRead` 程序中，是按行读取文件的是：


## 答案

```java
import java.io.*;

public class FileRead {
    public static void main(String[] args) throws IOException {
        String filePath = "test.txt";
        File file = new File(filePath);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String lineString = null;
        while ((lineString = reader.readLine()) != null) {
            System.out.println(lineString);
        }
        reader.close();
    }
}
```

## 选项

### A

```java
import java.io.*;

public class FileRead {
    public static void main(String[] args) throws IOException {
        String filePath = "test.txt";
        InputStream in = null;
        try {
            byte[] bytes = new byte[20];
            int length = 0;
            in = new FileInputStream(filePath);
            while ((length = in.read(bytes)) != -1) {
                System.out.write(bytes, 0, length);
            }
        } catch (Exception e1) {
            e1.printStackTrace();
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }
}
```

### B

```java

import java.io.*;

public class FileRead {
    public static void main(String[] args) throws IOException {
        String filePath = "test.txt";
        char[] chars = new char[20];
        int length = 0;
        Reader reader = new InputStreamReader(new FileInputStream(filePath));
        while ((length = reader.read(chars)) != -1) {
            String str = new String(chars, 0, length);
            System.out.print(str);
        }
    }
}
```

### C

```java

import java.io.*;

public class FileRead {
    public static void main(String[] args) throws IOException {
        String filePath = "test.txt";
        FileReader fr2 = new FileReader(filePath);
        char[] buf = new char[20];
        int length;
        while ((length = fr2.read(buf)) != -1) {
            String str = new String(buf, 0, length);
            System.out.print(str);
        }
    }
}
```