# 异常

已知我们有一个特殊的文件类型 PopFile，这个类型的对象方法 read() 可以返回字符串
数据，当读取到末尾的时候，会抛出 Eof 异常，我们希望先通过 PopFile.open(path)
新建一个对象，并从这样一个 PopFile 对象中读取最多一百个文本数据，然后调用 close 
方法关闭它。返回字符串列表`List<String>`。但是这个对象中的数据可能不足一百个。
此时我们需要在末尾添加一项 `[stop]`。

下列选项正确的是：

## 答案

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        try{
            for(int i=0; i<100; i++){
                result.add(popFile.read());
            }
        } catch(EofException eof){
            result.add("[stop]");
        } finally {
            popFile.close();
        }
        return reseult;
    }
}
```

## 选项

### A

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        try{
            for(int i=0; i<100; i++){
                result.add(popFile.read());
            }
            return result;
        } catch(EofException eof){
            result.add("[stop]");
            return result;
        } 
        popFile.close();
    }
}
```

### B

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        try{
            while(true){
                result.add(popFile.read());
            }
        } catch(EofException eof){
            if(result.size() < 100){
                result.add("[stop]");
            }
            return result;
        } finally {
            popFile.close();
        }
    }
}
```

### C

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        try{
            for(int i=0; i<100; i++){
                result.add(popFile.read());
            }
            return result;
        } catch(EofException eof){
            result.add("[stop]");
            return result;
        } finally {
            popFile.close();
        }
    }
}
```

### D

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        for(int i=0; i<100; i++){
            result.add(popFile.read());
        }
        if(result.size() < 100){
            result.add("[stop]");
        }
        popFile.close();
        return result;
    }
}
```

### E

```java
public class App{
    public List<String> Top100(String path){
        PopFile popFile = PopFile.open(path);
        List<String> result = new ArrayList();
        try{
            for(int i=0; i<100; i++){
                result.add(popFile.read());
            }
            if(result.size() < 100){
                result.add("[stop]");
            }
            return result;
        } catch(Excption error){
        } finally {
            popFile.close();
        }
        return result;
    }
}
```