from optparse import OptionParser


def parse_common_options(parser):
    '''
    ## 公共选项
    * -t 或者 --tag_id : 某个操作限制到指定tag_id的数据范围
    * --reset: 重置选项
    * --tag_name: 标签名字 
    * --model: 模型名字
    * --log: 日志级别
    * --train: 训练
    * --port: 端口
    * --show_config: 显示配置
    * --count: 指定数量
    * --query: 自定义查询
    '''
    parser.add_option(
        "-t", "--tag_id",
        dest="tag_id",
        help="tag_id",
        metavar="TAG_ID"
    )

    parser.add_option(
        "--reset",
        dest="reset",
        help="reset",
        action="store_true",
        metavar="RESET"
    )

    parser.add_option(
        "--tag_name",
        dest="tag_name",
        help="tag_name",
        metavar="TAG_NAME"
    )

    parser.add_option(
        "--model",
        dest="model",
        help="model",
        metavar="MODEL"
    )

    parser.add_option(
        "--log",
        dest="log",
        help="log",
        metavar="LOG"
    )

    parser.add_option(
        "--train",
        dest="train",
        help="train",
        action="store_true",
        metavar="TRAIN"
    )

    parser.add_option(
        "--port",
        dest="port",
        help="port",
        metavar="PORT"
    )

    parser.add_option(
        "--server",
        dest="server",
        help="server",
        metavar="SERVER"
    )

    parser.add_option(
        "--show_config",
        dest="show_config",
        help="show_config",
        metavar="SHOW_CONFIG"
    )

    parser.add_option(
        "--count",
        dest="count",
        help="count",
        metavar="COUNT"
    )

    parser.add_option(
        "--query",
        dest="query",
        help="query",
        metavar="QUERY"
    )


def parse_profile_options(parser):
    '''
    ## 环境配置选项
    * -p 或 --profile 指定配置环境,可选的有 `dev`, `fat`, `pre`, `pro`
    * 如果本地 config/config 目录下存在配置，则使用本地配置文件
    * 如果本地 config/config 目录下不存在配置，
        * 默认使用 阿波罗配置中心 cluster=dev 配置
        * 如果指定 --cluster，则使用指定 cluster 的阿波罗配置中心的配置
    '''

    parser.add_option(
        "-p", "--profile",
        dest="profile",
        help="profile",
        default='pro',
        metavar="PROFILE"
    )

    parser.add_option(
        "--cluster",
        dest="cluster",
        help="cluster",
        metavar="REMOTE"
    )


def parse_action_options(parser):
    '''
    ## 操作选项
    * -a 或 --action 指定了操作目标，多级目标用点号分割，例如: 
        * -a dataset.build.tag.all
        * -a server.ask
        * -a test.code
        * 参考[README](./README.md)
    '''
    parser.add_option(
        "-a", "--action",
        dest="action",
        help="action",
        metavar="ACTION"
    )


def parse_test_options(parser):
    '''
    ## 测试选项
    执行 -a test.xx 测试时默认执行冒烟测试，下面的选项改变行为
    * --label 指定执行测试并生成待标注数据
    * --count 指定标注上限
    '''
    parser.add_option(
        "--label",
        dest="label",
        help="label",
        action="store_true",
        metavar="LABEL"
    )


def parse_db_options(parser):
    '''
    ## 数据库 migrate 选项
    * --message 传入一个消息变量，db.migrate action 接收此参数
    * --revision 传入版本参数，db.upgrade, db.downgrade, db.stamp, db.show, db.edit 接受此参数
    '''
    parser.add_option(
        "--message",
        dest="message",
        help="message",
        metavar="MESSAGE"
    )
    parser.add_option(
        "--revision",
        dest="revision",
        help="revision",
        metavar="REVISION"
    )


def parse_options():
    parser = OptionParser()

    parse_common_options(parser)
    parse_profile_options(parser)
    parse_action_options(parser)
    parse_test_options(parser)
    parse_db_options(parser)

    (options, args) = parser.parse_args()
    return [options, args]


def show_help():
    '''
    命令行选项说明:
    ==
    '''

    help = '\n'.join([
        show_help.__doc__,
        parse_common_options.__doc__,
        parse_profile_options.__doc__,
        parse_action_options.__doc__
    ])

    print(help)
