# -*- coding: UTF-8 -*-
import os
import json
from lib.apollo import ApolloClient


def load_apollo_config(options):
    '''
    阿波罗配置加载
    ===
    * 如果是 `pro` 环境，则使用线上配置
    * 否则，使用内网配置
    '''
    config_url = None
    if options.cluster == 'pro':
        config_url = 'http://pro.config.csdn.net:8080'
    elif options.cluster == 'fat':
        config_url = 'http://fat.config.csdn.net:8080'
    elif options.cluster == 'uat':
        config_url = 'http://uat.config.csdn.net:8080'
    else:
        config_url = 'http://dev.config.csdn.net:8080'

    client = ApolloClient(
        app_id="949",
        cluster="default",
        config_url=config_url,
        start_hot_update=False
    )
    config = client.get_value("csdn-ai", namespace="application")
    return json.loads(config)


def load_config(options, args):
    '''
    配置加载
    ===
    * 如果本地 config/config 目录下存在配置，则使用本地配置文件
    * 如果本地 config/config 目录下不存在配置，
        * 默认使用 阿波罗配置中心 cluster=dev 配置
        * 如果指定 --cluster，则使用指定 cluster 的阿波罗配置中心的配置
    '''
    profile_path = "config/config/{}.json".format(options.profile)
    config = None
    if options.cluster:
        config = load_apollo_config(options)
    else:
        if os.path.exists(profile_path):
            with open(profile_path, "r") as f:
                config = json.loads(f.read())
        else:
            # try:
            #     options.cluster = 'dev'
            #     config = load_apollo_config(options)
            # except:
            config = {}
    return config
