# -*- coding: UTF-8 -*-
from common.logger import init_log

from config.config import load_config
from options import parse_options, show_help
from tree import gen_tree

def test(config, options, actions):
    import test as test
    test.dispatch(config, options, actions)

def tree(config, options, actions):
    import test as test
    gen_tree("../data")

def run(options):
    # 操作入口
    if options.action is not None:
        actions = options.action.split('.')
        if len(actions) == 0:
            return

        print('@init config...')
        config = load_config(options, args)
        print('')

        print('@init log...')
        init_log(config, options)
        print('')

        print('@dispatch action:{}...'.format(options.action))
        root_action = actions[0]
        next = actions[1:]
        dispatch = {
            'test': lambda: test(config, options, next),
            'tree': lambda: tree(config, options, next)
        }
        dispatch[root_action]()
    else:
        show_help()


if __name__ == "__main__":
    [options, args] = parse_options()
    run(options)
