# 生产者消费者

生产者消费者是软件开发者经常会用到的一种模式，以下代码是一种简单的实现：

```java
class Producter extends Thread {
    private BlockingQueue<String> queue;
    private String name;
    public Producter(String name, BlockingQueue<String> queue) {
        this.name = name;
        this.queue = queue;
    }
    @Override
    public void run() {
        for (int i = 0; i < 3; i++) {
            queue.add(name + i);
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
class Consumer extends Thread {
    private BlockingQueue<String> queue;
    public Consumer(BlockingQueue<String> queue) {
        this.queue = queue;
    }
    @Override
    public void run() {
        while (true) {
            if (queue.size() > 0) {
                String task = queue.poll();
                System.out.println(task);
            }
        }
    }
}
public class ThreadTest {
    public static void main(String[] args) {
        BlockingQueue<String> queue = new LinkedBlockingQueue<String>(20);
        // 1
    }
}
```

要输出的结果为

```
b0
b1
b2
a0
a1
a2
```

则1处的代码可以是下列选项中的哪一个？



## 答案

```java
new Producter("b", queue).start();
try {
    Thread.sleep(7000);
} catch (InterruptedException e) {
    e.printStackTrace();
}
new Producter("a", queue).start();
new Consumer(queue).start();
```

## 选项

### A

```java
new Producter("b", queue).start();
new Producter("a", queue).start();
new Consumer(queue).start();
```

### B

```java
new Producter("b", queue).start();
new Consumer(queue).start();
new Producter("a", queue).start();
```

### C

```java
new Producter("b", queue).start();
try {
    Thread.sleep(2000);
} catch (InterruptedException e) {
    e.printStackTrace();
}
new Producter("a", queue).start();
new Consumer(queue).start();
```
