# Files


下列对于 `Files` 的相关操作方法，错误的是：


## 答案

```java
// 复制文件，如果目的文件存在则会覆盖
public void copyFile(String sourcePath, String destPath) throws IOException {
    Path sp = Paths.get(sourcePath);
    Path dp = Paths.get(destPath);
    Files.copy(sp, dp);
}
```

## 选项

### A

```java
// 判断文件是否存在
public Boolean isExists(String filePath) {
    Path path = Paths.get(filePath);
    return Files.exists(path, new LinkOption[]{ LinkOption.NOFOLLOW_LINKS});
}
```

### B

```java
// 删除文件
public void deleteFile(String filePath) throws IOException {
    Path path = Paths.get(filePath);
    Files.delete(path);
}
```

### C

```java
// 创建文件
public void createFile(String filePath) throws IOException {
    Path path = Paths.get(filePath);
    Files.createFile(path);
}
```
