# Zip


以下 `Zip` 程序中，能正确完成对测试文件压缩的是：


## 答案

```java
import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    public static void main(String[] args) throws IOException {
        String zipFileName = "test.zip";
        String fileName = "test.txt";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        out.putNextEntry(new ZipEntry(""));
        FileInputStream in = new FileInputStream(file);
        int tmp;
        while((tmp = in.read()) != -1) {
            out.write(tmp);
        }
        in.close();
        out.close();
    }
}
```

## 选项

### A

```java
import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    public static void main(String[] args) throws IOException {
        String zipFileName = "test.zip";
        String fileName = "test.txt";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(zipFileName);
        out.putNextEntry(new ZipEntry(""));
        FileInputStream in = new FileInputStream(file);
        int tmp;
        while((tmp = in.read()) != -1) {
            out.write(tmp);
        }
        in.close();
        out.close();
    }
}
```

### B

```java
import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    public static void main(String[] args) throws IOException {
        String zipFileName = "test.zip";
        String fileName = "test.txt";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        out.putNextEntry();
        FileInputStream in = new FileInputStream(file);
        int tmp;
        while((tmp = in.read()) != -1) {
            out.write(tmp);
        }
        in.close();
        out.close();
    }
}
```

### C

```java
import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    public static void main(String[] args) throws IOException {
        String zipFileName = "test.zip";
        String fileName = "test.txt";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        out.putNextEntry(new ZipEntry(""));
        FileInputStream in = new FileOutputStream(file);
        int tmp;
        while((tmp = in.read()) != -1) {
            out.write(tmp);
        }
        in.close();
        out.close();
    }
}
```

