# 逻辑判断

在 `Login` 类型中，我们需要提供一个 `Optional<String> login(String key)` 函数，在函数中，调用
`boolean check(String key)` 函数，如果 key 通过了校验，调用 `String gen(String key)`
生成一个字符串 token ，否则返回 null 。那么下列实现中有错的是？

## 答案

```java
public class Login {
    public Optional<String> login(String key){
        Optional<String> token;
        if(!check(key))
            token = Optional.empty();
            return token;
        else
            token = Optional.of(gen(token));
            return token;
    }
    //...
}
```

## 选项

### A

```java
public class Login {
    public Optional<String> login(String key){
        Optional<String> token;
        if(check(key)){
            token = Optional.of(gen(token));
        } else {
            token = Optional.empty();
        }
        return token;
    }
    //...
}
```

### B

```java
public class Login {
    public Optional<String> login(String key){
        Optional<String> token = Optinal.empty();
        if(check(key)){
            token = Optional.of(gen(key));
        } 
        return token;
    }
    //...
}
```

### C

```java
public class Login {
    public Optional<String> login(String key){
        if(check(key)){
            return Optional.of(gen(key));
        } else {
            return Optional.empty();
        }
    }
    //...
}
```
