# ReflectTest


以下程序是关于反射的一个例子，程序的控制台打印为：
```java
public class Reflect {
    public static void main(String[] args) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class clazz = Student.class;
        Constructor con = clazz.getConstructor(String.class, Integer.class);
        Student student1 = (Student) con.newInstance("小铭", 24);
        Student student2 = new Student("小铭", 24);
        System.out.println(student2 == student1);
        System.out.println(student2.equals(student1));
    }
}
```

## aop

### before

```java
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class Student {
    private String name;
    private Integer age;

    public Student() {}

    public Student(String name, Integer age) {
        this.name = name;
        this.age = age;
    }

    @Override
    public String toString() {
        return "Student{" +
                "name='" + name + '\'' +
                ", age=" + age +
                '}';
    }
}
```

## 答案

```
false
false
```

## 选项

### A

```
false
true
```

### B

```
true
false
```

### C

```
true
true
```
