# 变量和赋值

假设有a b两个整形变量，交换他们的值，可以用下列代码中的：

## aop

### before

```java
int a = 10;
int b = 20;
System.out.printf("before swap: a=%d, b=%d\n", a, b);
```

### after

```java
System.out.printf("after swap: a=%d, b=%d\n", a, b);
```

## 答案

```java

int tmp = a;
a = b;
b = tmp;

```

## 选项

### 常量使用错误

```java
const int tmp = a;
a = b;
b = tmp;
```

### 类型错误

```java
auto tmp = a;
a = b;
b = tmp;
```

### Java 没有指针

```java
int* tmp = &a;
a = b;
b = tmp;
```

### 变量未定义

```java
tmp = a;
a = b;
b = tmp;
```
