# UDP


观察以下关于 `UDP` 的程序，接收端的输出为：
```java
// 省略import
public class UDPSender {
    public static void main(String[] args) throws Exception {
        String[] messages = {"你好！", "我叫小白", "很高兴认识你"};
        DatagramSocket ds = new DatagramSocket();
        for (String message: messages) {
            byte[] data = message.getBytes(StandardCharsets.UTF_8);
            DatagramPacket dp = new DatagramPacket(data, data.length,
                    InetAddress.getLocalHost(),8080);
            ds.send(dp);
            Thread.sleep(1000);
        }
        ds.close();
    }
}
```
```java
// 省略import
public class UDPReceive {
    public static void main(String[] args)throws Exception{
        DatagramSocket ds = new DatagramSocket(8080);
        byte[] data = new byte[1024];
        while (!ds.isClosed()) {
            DatagramPacket dp = new DatagramPacket(data, data.length);
            ds.receive(dp);
            int len = dp.getLength();
            System.out.println(new String(data, 0, len));
        }
        ds.close();
    }
}
```

## 答案

```
你好！
我叫小白
很高兴认识你
```

## 选项

### A

```
￤ﾽﾠ￥ﾥﾽ￯ﾼﾁ
￦ﾈﾑ￥ﾏﾫ￥ﾰﾏ￧ﾙﾽ
￥ﾾﾈ￩ﾫﾘ￥ﾅﾴ￨ﾮﾤ￨ﾯﾆ￤ﾽﾠ
```

### B

```
很高兴认识你
```

### C

```
啥都不输出
```
