# PSQL Connection


以下程序中，正确连接postgre数据库的是：


## 答案

```java
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class PSQLConnection {
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/test");
            Statement stmt = conn.createStatement();

            String sql = "CREATE TABLE student " +
                    "(id INTEGER not NULL, " +
                    " name VARCHAR(255), " +
                    " sex VARCHAR(255), " +
                    " age INTEGER, " +
                    " PRIMARY KEY ( id ))";

            stmt.executeUpdate(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}
```

## 选项

### A

```java
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class PSQLConnection {
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            conn = new Connection("jdbc:postgresql://dev-cloud.csdn.net:5432/test");
            Statement stmt = conn.createStatement();

            String sql = "CREATE TABLE student " +
                    "(id INTEGER not NULL, " +
                    " name VARCHAR(255), " +
                    " sex VARCHAR(255), " +
                    " age INTEGER, " +
                    " PRIMARY KEY ( id ))";

            stmt.executeUpdate(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}
```

### B

```java
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class PSQLConnection {
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection("jdbc:postgresql://root+root@localhost:5432/test");
            Statement stmt = conn.createStatement();

            String sql = "CREATE TABLE student " +
                    "(id INTEGER not NULL, " +
                    " name VARCHAR(255), " +
                    " sex VARCHAR(255), " +
                    " age INTEGER, " +
                    " PRIMARY KEY ( id ))";

            stmt.executeUpdate(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}
```

### C

```java
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class PSQLConnection {
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            conn = new Connection("jdbc:postgresql://localhost/test", "root", "root");
            Statement stmt = conn.createStatement();

            String sql = "CREATE TABLE student " +
                    "(id INTEGER not NULL, " +
                    " name VARCHAR(255), " +
                    " sex VARCHAR(255), " +
                    " age INTEGER, " +
                    " PRIMARY KEY ( id ))";

            stmt.executeUpdate(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}
```
