# Foreach

现在有一个 `List<String>` 列表，我们希望遍历它，得到其中有多少个单词，列表中的
每个元素可能包含一个或多个单词，单词间用空格分割，那么下面哪个实现是对的？

## 答案

```java
public class App {
    public int words(List<String> content){
        int count = 0;
        for(var str: content){
            var tokens = str.split(" ");
            count += tokens.length;
        }
        return count;
    }
}
```

## 选项


### A

```java
public class App {
    public int words(List<String> content){
        int count = 0;
        for(int i=0; i< content.size(); i++){
            count += i;
        }
        return count;
    }
}
```

### B

```java
public class App {
    public int words(List<String> content){
        int count = 0;
        for(Character w: content){
            if(w == ' '){
                count += 1;
            }
        }
        return count;
    }
}
```

### C

```java
public class App {
    public int words(List<String> content){
        int count = 0;
        for(String w: content){
            for(Character c: w){
                if(w == ' '){
                    count += 1;
                }
            }
        }
        return count;
    }
}
```