# 二分

现有一个数据流 `Stream<Integer> stream`， 下列代码尝试把它按正负号分为两部分（不拘于某种结果类型，能够区分两类数据即可），其中有错的是？

## 答案

```java
Stream<Integer> upstream=stream.filter(x->x>=0);
Stream<Integer> downstream=stream.filter(x->x< 0);
```

## 选项

### 常规方法

```java
Collectors.partitionBy(x->x>=0,stream);
```

### 常规方法

```java
Collector<Integer, ?, Map<Boolean, List<Integer>>>collector=Collectors.partitioningBy(x->x>0);
stream.collect(collector);
```

### 朴素方法

```java
List<Integer> upstream=new ArrayList<>();
List<Integer> downstream=new ArrayList<>();

stream.foreach(x->{
    if(x>=0){
        upstream.add(x);
    }else{
        downstream.add(x);
    }
})
```