# Buffer Read


以下关于 `Buffer` 的使用，正确的是：


## 答案

```java
import java.nio.DoubleBuffer;

public class BufferTest {
    public static void main(String[] args) {
        DoubleBuffer doubleBuffer = DoubleBuffer.allocate(10);
        doubleBuffer.put(12.0);
        doubleBuffer.put(25.0);
        doubleBuffer.flip();
        System.out.println(doubleBuffer.get());
        System.out.println(doubleBuffer.get());
        doubleBuffer.clear();
    }
}
```

## 选项

### A

```java
import java.nio.CharBuffer;

public class BufferTest {
    public static void main(String[] args) {
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charBuffer.put("test");
        charBuffer.flip();
        System.err.println(charBuffer.get());
    }
}
```

### B

```java

import java.nio.IntBuffer;

public class BufferTest {
    public static void main(String[] args) {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        intBuffer.put(25);
        intBuffer.put(12);
        intBuffer.flip();
        System.err.println(intBuffer.get());
        System.err.println(intBuffer.get());
    }
}
```

### C

```java
import java.nio.ByteBuffer;

public class BufferTest {
    public static void main(String[] args) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byte a = 12;
        byteBuffer.put(a);
        System.err.println(byteBuffer.get());
    }
}
```
