## 输入描述

<p>第一行分别输入两个整数 <code>m</code>,<code>n</code> 表示数组的行数和列数 </p>
<p>接下来输入 <code>m</code> 行， <code>n</code> 个整数</p>

<p>m,n均小于100000</p>

## 输出描述
输出整数数组中最大子数组的和

## 输入样例
3 6
5 6 -3 8 -9 2
1 -12 20 0 -3 -5
-9 -7 -3 6 7 -1

## 输出样例
28

## 提示

子数组：

<pre><code>-3 8
20 0
-3 6
</code></pre>


一维数组最大子数组和参考代码：

<pre><code class="language-c">#include &lt;stdio.h&gt;
#include &lt;string.h&gt;

int MaxSum(int *arr, int size)
{
    int current = arr[0];
    int max = current;

    for (int i = 0; i &lt; size; i++)
    {
        if (current &lt; 0)
            current = 0;
        current += arr[i];
        if (current &gt; max)
            max = current;
    }
    return max;
}

int main(void)
{
    char x[40], y[40];

    int a1[5] = {-1, 5, 6, -7, 3};
    int a2[5] = {-5, -4, -8, -1, -10};
    int a3[5] = {-1, 5, 6, -7, 10};

    int max1, max2, max3;
    max1 = MaxSum(a1, 5);
    max2 = MaxSum(a2, 5);
    max3 = MaxSum(a3, 5);
    printf(&quot;%d\n&quot;, max1);
    printf(&quot;%d\n&quot;, max2);
    printf(&quot;%d\n&quot;, max3);
}
</code></pre>


