# 实用Linux命令掌握20%：grep

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

**本节知识**：

假设文件`1.txt`的文本如下（可以利用`touch`命令和`vi`命令组合创建）：

```bash
1. hello world
2. wold hello
3. nothing is important
4. i like movie movie
hello world
wold hello
nothing is important
i like movie movie
```

`grep` 命令用来查找文本，这里是最常用的几个操作例子：

* 查找文件`1.txt`中含有`"hello"`字符串的行：`grep hello 1.txt`
* 使用正则表达式查找文件`1.txt`中含有数字的行：`grep -E "\d." 1.txt`
* 查找文件`1.txt`中不包含`"hello"`字符串的行：`grep -v hello 1.txt`
* 查找文件`1.txt`中含有`"movie"`字符串的行以及它前面的3行：`grep movie -B 3 1.xt`
* 查找文件`1.txt`中含有`"movie"`字符串的行以及它后面的3行：`grep movie -A 3 1.xt`
* 查找文件`1.txt`中含有`"4."`字符串的行以及它前后3行：`grep 4. -C 3 1.txt`

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习上述`grep`命令。
2. 以下对命令`grep`描述错误的是？

## 答案

```bash
`grep`命令不能对文件夹递归查找，例如
`grep "text" . -r -n`
```

## 选项

### A

```bash
如果要查找包含某个字符串的行的前后3行
可以使用 `grep -C 3 xxx.log` 命令
C 表示 center
```

### B

```bash
`grep`命令的匹配参数默认是普通的通配符
`grep`命令的通过`-E`选项来指定正则表达式匹配
```

### C

```bash
`grep`命令可以通过通配符查找多个文件，例如`grep hello *.txt`
```
