# 认识终端(Terminal)

无论是Windows，Mac，还是Linux操作系统，都可以通过这组操作让操作系统执行命令。

1. 打开`终端`。
2. 在`终端`的命令行里输入`命令`。
3. 回车，`终端`将`命令`传递给`shell`程序解释。
4. `shell`程序解释`命令`后，调用对应的操作系统接口执行。
5. `shell`程序将执行结果返回给`终端`显示。

对`终端`和`shell`的通俗解释：

* `shell`:
  * 解析输入命令并传递给操作系统的程序，并把操作系统反馈信息输出的程序，是`shell`
* `终端`：
  * GUI下，把GUI下管理`shell`的程序（负责让`shell`能在GUI下交互、以及同时开启多个`shell`等叫做`terminal`）
  * 非GUI下，只有纯文本界面，Linux`终端`包含3类：
    * 把`shell`和`本地显示器交互`的机制叫做`tty`
    * 把`shell`和`远程访问交互`的机制叫做`pts`
    * 把`shell`和`串口设备交互`的机制叫做`console`
    * 其中最具争议的是`console`。因为有一些GUI下调用`shell`的GUI程序，也叫做`console`

每个操作系统都有多种可选的终端程序。

* Windows 系统
  * 安装[Windows 终端](https://docs.microsoft.com/zh-cn/windows/terminal/install)
  * 一般来说，Window 的`cmd.exe`和`powershell.exe`，当作为一个`console`的时候，算是一个`终端`；
  * 当你在`cmd`或者`powershell`里运行任何命令的时候，这些命令是`cmd`和`powershell`负责解析并运行的，此时他们就是`shell`角色
* Ubuntu 系统
  * 系统自带的终端
  * 通过命令安装其他Linux终端程序, 例如安装名为`Terminator`的Linux终端：`sudo apt install terminator`
* Mac 系统
  * 使用系统自带的终端
  * 安装[iterm2终端](https://iterm2.com/)

根据上述材料，下列哪些说法是错误的

## 答案

每个终端只能运行一种shell程序。

## 选项

### A

Mac系统自带的终端和`iterm2`都是终端，只是除了基本功能外一些功能上有差异。

### B

Ubuntu自带的终端和安装的`Terminator`都是终端，只是除了基本功能外一些功能上有差异。

### C

这个链接可以安装Windows最新的终端：`https://docs.microsoft.com/zh-cn/windows/terminal/install`
