# 实用Linux命令掌握20%: df

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

<br/>
**本节知识**：

命令`df`和`du`配合用来查看空间占用情况。

* `df` 命令用来查看磁盘的空间占用情况
    * 其中选项`-h`表示以K，M，G为单位，提高信息的可读性
* `du` 命令用来查看目录的空间占用情况，默认会统计到所有子目录
    * 其中选项`-h`表示以K，M，G为单位，提高信息的可读性
    * 其中选项`-s`表示只显示统计汇总信息

这两个命令都有很多选项，常用的例子是：

* 查看系统磁盘的空间占用情况：`df -h`
* 查看指定目录的空间占用情况：`du /var/ -h`
* 查看指定目录的空间占用情况，只显示汇总信息：`du /var/ -sh`
* 查询指定目录下的直接子目录空间占用情况，只显示汇总信息：`du /var/*/ -sh`

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习上述`df`和`du`命令。
2. 以下对命令`du`和`df`描述错误的是？

假设当前目录是`/home/csdn/`，下层目录结构是：

```bash
.
├── Code
├── doc
│   └── 3.txt
└── test
    ├── 1.txt
    └── test
        └── 2.txt
```

## 答案

```bash
查看`/home/csdn/`目录下的所有直接子文件夹的空间占用命令是：
`du -h /home/csdn/*/`
```

## 选项

### A

```bash
查看`/home/csdn/`目录下的所有直接子文件夹的空间占用命令是：
`du -sh /home/csdn/*/`
```

### B

```bash
查看`/home/csdn/`目录下的所有子文件夹的空间占用命令是：
`du -h /home/csdn`
```

### C

```bash
查看`/home/csdn/`所在磁盘的空间命令是：
`df -h /home/csdn`
```
