# 实用Linux命令掌握20%: tcpdump

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

请准备一个Linux主机，如果你本机是Linux环境，或者你的虚拟机是Linux环境都可以。前提准备：

* 安装`tcpdump`命令：`sudo yum install tcpdump`
* 安装`nc`命令：`sudo yum install nc`

**例子1，监听指定域名TCP协议数据包**：

操作一，开始监听指定域名的ip包流量：`tcpdump host csdn.net`。
操作二，打开浏览器，访问 csdn.net
此时，命令行下可以看到客户端和CSDN服务之间的TCP协议IP包，学习网络协议的时候，配合使用很方便。

**例子2，监听来自指定域名的TCP协议包数据包**：
操作一，开始监听指定域名的ip包流量：`tcpdump src host csdn.net`。
操作二，打开浏览器，访问 csdn.net
此时，命令行下可以看到客户端和CSDN服务之间的TCP协议IP包，学习网络协议的时候，配合使用很方便。

**例子3，监听发送到指定域名的TCP协议包数据包**：
操作一，开始监听指定域名的ip包流量：`tcpdump dst host csdn.net`。
操作二，打开浏览器，访问 csdn.net
此时，命令行下可以看到客户端和CSDN服务之间的TCP协议IP包，学习网络协议的时候，配合使用很方便。

**例子4，监听指定端口的tcp包**：
操作一，开始监听：`tcpdump tcp port 80`。
操作二，打开另外一个终端，使用`nc 192.168.1.1 80`命令访问80端口。
此时，tcpdump监听终端下可以看到请求和返回的ip包。同理，如果要监听udp包可以用：`tcpdump udp port 9999`

**例子5，使用 and 组合逻辑**：
操作一，开始监听指定域名的ip包流量：`tcpdump tcp port 80 and src host 192.168.1.1`。
操作二，打开另外一个终端，使用`nc 192.168.1.1 80`命令访问80端口。
此时，可以看到只输出请求包。

**问题**：以下对命令`tcpdump`描述错误的是？

## 答案

```bash
tcpdump 只能监听 tcp 网络包，不能监听 udp 包
```

## 选项

### A

```bash
使用 tcpdump 可以监听来自指定域名的IP包
使用 tcpdump 可以监听发往指定域名的IP包
```

### B

```bash
使用 tcpdump 可以通过`and`来组合指定监听条件
```

### C

```bash
使用 tcpdump 可以监听某个端口的tcp或者udp包
```
