# skill_tree_git_md_linux

`CS入门技能树`是[技能森林](https://gitcode.net/csdn/skill_tree)的一部分

## 初始化

```bash
pip install -r requirement.txt
```

## 目录结构说明

* 技能树`骨架文件`：
  * 位置：`data/tree.json`
  * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
  * 位置：`data/config.json`
  * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
  * 位置：`data/xxx`，例如: `data/1.gml初阶`
  * 说明：
    * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
  * 位置：`data/xxx/xxx`，例如：`data/1.gml初阶/1.Git入门`
  * 说明：
    * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
  * 位置：`data/xxx/xxx`，例如：`data/1.gml初阶/1.Git`
  * 说明：
    * 每个技能树的每章有 n 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json`
      * 其中 `node_id` 字段是生成的，请勿编辑
      * 其中 `keywords` 可配置关键字字段
      * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
      * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述

## `知识节点` 子树信息结构

例如 `data/1.gml初阶/1.Git入门/1.Git简介/config.json` 里配置对该知识节点子树信息结构：

```json
{
  // ...

  "children": [
    
  ],
}
```

## `知识节点` 的导出习题选项配置编辑

目前我们支持使用 markdown 语法直接编辑习题和各选项。

首先，编辑知识节点的配置，导出习题：

```json
{
  // ...
  "export": [
    "learn.json"
  ]
}
```

然后在 `data/1.gml初阶/1.Git入门/1.Git简介/` 下增加一个`learn.json`定义文件：

```json
{
  "type": "code_options",
  "author": "ccat",
  "source": "helloworld.md",
  "notebook_enable": true
}
```

其中 type 字段目前都固定是 `code_options`，notebook_enable 字段决定这个习题是否生成对应的 notebook 。根据具体情况写好其它字段，注意这里 source 的文件名，我们指定了一个 markdwon 文件。现在我们新建一个 learn.md 并编辑为：

````mardown
# Git简介

* 你了解版本控制系统吗？
* 什么是本地版本控制系统
* 什么是集中化的版本控制系统
* 什么是分布式版本控制系统
* Git 诞生的故事

请点击[Git简介](https://codechina.csdn.net/courses/register/1/1){target="_blank"} 并完成所有题目，完成学习请关闭Issue。

以下哪个选项是[Git简介](https://codechina.csdn.net/courses/register/1/1){target="_blank"}里的最后一个选择题题目？

## 答案

```bash
以下哪个不属于 Git 的优点？
```

## 选项

### A

```bash
你知道 Git 属于哪种版本控制系统吗？ 
```

### B

```bash
下列哪个不是版本控制系统的正确使用方式？
```

### C

```bash
Git 是谁发明的？
```

````

## 技能树合成

在根目录下执行 `python main.py` 会合成技能树文件，合成的技能树文件: `data/tree.json`

* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
