# 实用Linux命令掌握20%: 管道(pipeline)

我们学习了许多个Linux命令，但是只靠单个命令还只能发挥出Linux命令有限的能力。管道是unix 哲学的核心之一，Linux管道设计源自Unix。通过管道(pipeline)可以组合多个命令来完成一系列的操作。

**本节知识**：

* 通过管道符号`"|"`，可以组合多个管道命令。
* 例如，使用`cat`命令读取全文，接着使用`grep`命令过滤出含有字符串`"hello"`的行： `cat 1.txt|grep hello`
* 管道符连接的前后两个命令，前面的命令的输出需要是标准输出，后面的命令要需要能接受标准输入

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习管道命令。
2. 以下对管道使用错误的是？

## 答案

```bash
命令 `vi` 的输出不是标准输出

从而，可以编辑并过滤文本：
`vi test.txt|grep hello`
```

## 选项

### A

```bash
`ll`命令可以显示目录下的文件信息，每个文件一行
`wc -l`命令可以统计函数

那么，统计目录下文件个数的管道命令组合是：
`ll|wc -l`
```

### B

```bash
`tail -f`命令可以监控某个日志文件的最新增加的日志

那么，可以监控日志文件里最新增加的含有"Error"的日志
`tail -f 1.log|grep Error`
```

### C

```bash
`sort` 命令可以对文本行排序

那么，可以搜索并排序结果
`grep hello *.log|sort`
```
