# 实用Linux命令掌握20%: sed

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

**本节知识**：

假设文件`1.txt`的文本如下（可以利用`touch`命令和`vi`命令组合创建）：

```bash
1. hello hello world
2. wold hello hello
3. nothing is important
4. i like movie movie

hello hello world
wold hello hello

nothing is important
i like movie movie
```

`sed` 命令可以用来替换文本行、删除文本行，例子如下：

* 查找并替换每行第一个`"hello"`为`"你好"`： `sed 's/hello/你好/' 1.txt`
* 查找替换每行中所有的`"hello"`为`"你好"`： `sed 's/hello/你好/g' 1.txt`
* 删除含有`"hello"`的行：`sed '/hello/d' 1.txt`
* 删除第2行：`sed '2d' 1.txt`
* 删除第最后一行：`sed '$d' 1.txt`
* 删除第2行到最后一行：`sed '2,$d' 1.txt`

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习上述`sed`命令。
2. 以下对命令`sed`描述错误的是？

## 答案

```bash
查找并替换每行所有"world"为"世界"
`sed '/world/世界/g' 1.txt`
```

## 选项

### A

```bash
删除第3行到第5行的命令是：
`sed 3,5d 1.txt`
```

### B

```bash
正则表达式里：'^' 表示行开头
正则表达式里：'\s' 表示空格
正则表达式里：'$' 表示行末

那么，删除空行命令是：
`sed '/^\s*$/d' 1.txt`
```

### C

```bash
查找并替换每行所有"world"为"世界"
`sed 's/world/世界/g' 1.txt`
```
