# 极简 Git+VSCode for Mac(4): 使用VSCode添加MarkDown文件到Git仓库


如图所示，在VSCode的左侧导航列表里，使用右键菜单新建一个目录：doc，并在doc目录下新建一个MarkDown文件`test.md`
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_01.png)

<br/>
如图所示，在`test.md`里编辑几行MarkDown文本（MarkDown语法请学习本技能树第二章），并保存。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_02.png)

<br/>
如图所示，点击VSCode左侧的“Git面板按钮”，切换左侧导航栏。可以看到按钮上也显示里一个数字1，表示有一个文件发生变动。这里是新增了一个test.md文件。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_03.png)

<br/>
如图所示，在“源代码管理”下的输入框里输入一个提交信息，这里输入“第一次提交”。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_04.png)

<br/>
如图所示，在打勾图标的“提交”按钮，将文件的变动提交到Git本地。注意这里的提交只是将变动的文件提交到Git的本地索引系统里，还并不是提交到Git远程仓库。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_05.png)

<br/>
如图所示，弹框会提示你还没有可提交到暂存更改。这是由于将文件变动提交到Git本地索引是需要两个步骤的，先将文件变动加入到暂存更改，再将暂存更改提交到Git本地索引。这里只需要点击「是」，VSCode会自动把两个步骤都做掉。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_06.png)

<br/>
如图所示，提交后，VSCode左侧按钮栏的“Git面板按钮”上的数字消失了。我们希望将本地修改推送到GitCode的远程仓库。但是GitCode仓库上，仓库的其他成员可能也添加了文件，因此一般需要在推送前先拉取下变动到本机，如果拉取的过程中远程仓库的文件和本地的文件有冲突，则需要解决冲突，如何解决冲突不在本节考虑的范围。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_10.png)

<br/>
如图所示，我们进一步点击下来菜单，点击“推送”按钮，将Git仓库的本地索引变动推送到GitCode上的远程仓库。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_07.png)

<br/>
如图所示，Mac系统可能会提示你输入GitCode仓库的用户名密码，或者之前已经配置过，但是首次推送也会提示是否允许使用。根据提示做相应的授权即可。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_08.png)

<br/>
如图所示，推送成功后，打开GitCode的 hello_git 仓库，可以看到新增的doc/test.md文件已经提交到仓库。
<br/>

![](https://gitcode.net/csdn/skill_tree_git_md_linux/-/raw/master/data/1.gml%E5%88%9D%E9%98%B6/1.Git%E5%85%A5%E9%97%A8/7.%E6%9E%81%E7%AE%80Git+VSCode(Mac)/img/first_commit_09.png)

<br/>
经过这些操作，你已经学会了在VSCode里给Git仓库添加文件，提交到Git本地索引，拉取远程Git仓库变动到本机，再推送本地Git仓库的变动到远程仓库。以下描述错误的是？

## 答案

```bash
Git仓库文件编辑后，提交变动到Git后，文件就已经推送到了远程仓库。
```

## 选项

### A

```bash
一般情况下推送数据到远程仓库之前，最好先拉取下远程仓库的变动到本地，可能的话需要解决冲突。
```

### B

```bash
VSCode 里文件变动后直接点提交实际上会提示你是否先将文件变动添加到Git的暂存区，再进一步将暂存区变动提交到Git本地索引。
```

### C

```bash
Git 仓库的文件发生变化后，VSCode左侧的Git面板按钮上会显示有变动的文件个数。
```

