# WSL 2

** WSL 2 利用 Windows 虚拟化技术 Hyper-V  提供了更完整的 Linux 功能，但是也导致对大多数其他虚拟机产品的冲突。尤其是在其他虚拟机产品启用了硬件加速功能的时候。因此建议大家根据实际需求选择是否适用 WSL 2。**

## 如何解决 WSL 和其他虚拟机产品的冲突问题

### 方案 1：禁用其他虚拟机的硬件加速功能以支持 WSL 2

这个方法根据不同的虚拟机产品，开关在不通的地方，因此不作细表。

### 方案 2：关闭 WSL 2 以兼容其他虚拟机(推荐)

使用 Windows 管理员账户在 PowerShell 下执行命令```Disable-WindowsOptionalFeature -Online -FeatureName VirtualMachinePlatform``` 关闭 WSL 特性

如果你要恢复 WSL 2 支持，命令是```Enable-WindowsOptionalFeature -Online -FeatureName VirtualMachinePlatform```

## WSl 2 的特点

从我个人角度，WSL 2 带来的好处有

* 完整的虚拟化技术，带来完整的 Linux 特性支持
  * 支持 docker
  * Linux 内核相关的特性支持
  * 更好的磁盘读写性能

WSL 2 带来的问题主要在于和其他虚拟化产品的冲突，以及丧失 WSL 内部文件和 Windows 之间的快速共享特性，用人话说就是你在 WSL 和 Windows 之间拷贝文件变得很麻烦了。

如果我们把 WSL 用作一个开发环境，并不需要太高的性能以及完全的 Linux 特性支持，我觉得 WSL 2 的弊端是比好处多的。所以我个人选择不启用。

## 如何使用 WSL 2

默认启用 WSL 2

```wsl --set-default-version <Version>```

指定某个 WSL 实例为 WSL 或者 WSL 2

```wsl --set-version <distribution name> <versionNumber>```

哪种描述是不正确的

## 答案

Windows 如果要访问 WSL 2 实例中的文件，可以通过在文件管理器或者运行命令中输入 ```\\wsl$``` 实现

## A

Windows 如果要访问 WSL 实例中的文件，可以通过在文件管理器或者运行命令中输入 ```\\wsl$``` 实现

## B

WSL 2 不一定比 WSL 更好

## C

WSL 2 依赖于 Windows Hyper-V 虚拟机
