# 实用Linux命令掌握20%: curl和wget

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

<br/>
**本节知识**：

curl 和 wget 命令都可以用来下载文件和在命令行下发起 http 请求。

wget 常用来下载文件，下载命令用例：

* 下载文件：`wget https://img-home.csdnimg.cn/images/20211024040633.png`
* 在文本文件`1.txt`里配置url列表，每行一个url地址，然后下载：`wget -i 1.txt `
* 文件比较大时，下载中断后要重新下载很麻烦，wget支持断点续传：`wget -c https://img-home.csdnimg.cn/images/20211024040633.png`

curl 常用来测试HTTP请求，用例：

* 执行HTTP Get请求：`curl "https://cn.bing.com"`
* 假设有一个网络API是一个HTTP POST接口，请求的参数和返回的参数都指定为JSON格式，请求的JSON必须指定'user'和'password'字段，那么执行HTTP POST请求登陆，命令格式为：`curl -H "Content-type: application/json" -H "Accept: application/json" -X POST -d '{"user":"xxx","password":"..."}' https://example.net/login`，两个`-H`参数指定HTTP请求头。 `-X POST` 指定了请求方法为POST，`-d`指定了POST请求的参数，这里是一个JSON字符串。

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习上述`df`和`du`命令。
2. 以下对命令`curl`和`wget`描述错误的是？

## 答案

```bash
wget 命令不能用来执行 HTTP GET 请求
```

## 选项

### A

```bash
wget 可以通过选项`-c`指定断点续传
```

### B

```bash
curl 可以通过选项`-d`指定请求参数
```

### C

```bash
curl 可以通过选项`-H `设置请求头字段
```
