# 实用Linux命令掌握20%: netstat

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

请准备一个Linux主机，如果你本机是Linux环境，或者你的虚拟机是Linux环境都可以。前提准备：

* 安装`netstat`命令：`sudo yum install netstat`

**本节知识**：

命令`netstat`用来查看网络状态，选项很多，但是拆开成两个维度后就可以方便组合。

首先，指定查看的范围选项：

* `-a`选项表示查看所有连线中的socket
* `-l`选项表示查看监听中的socket

其次，指定查看的协议类型：

* `-t`选项表示tcp
* `-u`选项表示udp

Linux的大多数命令行选项可以组合，上述两个维度组合后有多种可能：

* 查看所有 socket 状态：`netstat -a`
* 查看所有 tcp socket 状态：`netstat -at`
* 查看所有 udp socket 状态：`netstat -au`
* 查看所有监听中的 socket 状态：`netstat -l`
* 查看所有监听中的 tcp socket 状态：`netstat -lt`
* 查看所有监听中的 udp socket 状态：`netstat -lu`

**问题**：以下对命令`netstat`描述错误的是？

## 答案

```bash
执行命令：`netstat -at` 
可以查看所有的 udp socket状态
```

## 选项

### A

```bash
执行命令：`netstat -au` 
可以查看所有的 udp socket状态
```

### B

```bash
执行命令：`netstat -lu` 
可以查看监听中的 udp socket状态
```

### C

```bash
执行命令：`netstat -lt` 
可以查看监听中的 tcp socket状态
```
