# 实用Linux命令掌握20%: lsof

Linux 命令很多，掌握最实用的一批命令，对于每个实用命令，又只需掌握20%最高频操作。

**本节知识**：

命令`lsof` 有很多选项，可以用来查看“文件打开的进程”、“进程打开的文件”，“进程打开的TCP或者UDP端口”，“占用了某个TCP或者UDP端口的进程”等。最常用的有如下几个：

* -a：列出打开文件存在的进程；
* -c<进程名>：列出指定进程所打开的文件；
* -d<文件号>：列出占用该文件号的进程；
* -p<进程号>：列出指定进程号所打开的文件；
* -i<条件>：列出符合条件的进程（协议、:端口、 @ip ）

`lsof` 经常被用来诊断服务端端口占用情况，进程打开文件等，例子如下：

* 某一个HTTP服务无法启动，例如提示端口8888已被占用，此时可以用：`lsof -i :8888`查看哪个进程占用了8888端口
* 列出进程620所打开的文件：`lsof -p 620`
* 监听tcp链接进程信息：`lsof -i tcp`

**本节任务**：

1. 请在[线上Linux环境](https://edu.csdn.net/lab/36675?targetLesson=2692)里练习上述`lsof`命令。
2. 以下对命令`lsof`描述错误的是？

## 答案

```bash
查看占用了3306的进程：
`lsof -i 3306`
```

## 选项

### A

```bash
查看使用了udp协议的进程：
`lsof -i udp`
```

### B

```bash
查看占用了tcp端口9999的进程：
`lsof -i tcp:9999`
```

### C

```bash
查看占用了tcp端口9999的进程，并杀死进程步骤：
* 使用`lsof -i tcp:9999`查看，记住进程号，例如43457
* 使用`kill -9 43457`杀死进程43457
```
