# skill_tree_.NET

C# 技能树

## 初始化技能树

技能树合成和id生成脚本目前用Python脚本统一处理

```bash
pip install -r requirement.txt
```


## 目录结构说明

data目录下包含 难度节点/章节点/知识节点 3级目录结构

* 技能树`骨架文件`：
    * 位置：`data/tree.json` 
    * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
    * 位置：`data/config.json`
    * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
    * 位置：`data/xxx`，例如: `data/1..NET初阶`
    * 说明：
        * 每个技能树有 3 个等级，目录前的序号是**必要**的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1..NET初阶/1.入门`
    * 说明：
        * 每个技能树的每个难度等级有 n 个章节，目录前的序号是**必要**的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
    * 位置：`data/xxx/xxx`，例如：`data/1..NET初阶/1.入门/1.Hello World`
    * 说明：
        * 每个技能树的每章有 n 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
        * 每个目录下有一个 `config.json`
            * 其中 `node_id` 字段是生成的，请勿编辑
            * 其中 `keywords` 可配置关键字字段
            * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
            * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述


## `知识节点` 子树信息结构

例如 `data/1..NET初阶/1.入门/1.Hello World/config.json` 里配置对该知识节点子树信息结构，用来增加技能树服务在该知识节点上的深度数据匹配：

```json
{
    // ...

    "children": [
        {
            ".NET的起源": {
                "keywords": [
                    "c#的起源",
                    "起源",
                    "c#"
                ],
                "children": []
            }
        }
    ],
}
```


## `知识节点` 的导出习题编辑

例如 `data/1..NET初阶/1.入门/1.Hello/config.json` 里配置对该知识节点导出的习题

```json
{
    // ...
    "export": [
        "HelloWorld.json",
        // ...
    ]
}
```

在 `export` 字段中，我们列出习题定义的`json`文件列表 ，下面我们了解如何编写习题。

## `知识节点` 的导出习题选项配置编辑

目前我们支持使用 markdown 语法直接编辑习题和各选项。

如前文内容，我们在知识节点下增加习题 `helloworld`的定义文件，即在`data/1..NET初阶/1.入门/1.Hello World` 目录增加一个`HelloWorld.json`文件：

```json
{
    "type": "code_options",
    "author": "幻灰龙",
    "source": "HelloWorld.md",
    "notebook_enable": true
}
```

其中

* `type` 字段目前都固定是 `code_options`，
* `notebook_enable` 字段决定这个习题是否生成对应的 `notebook` 
* `source` 字段代表习题编辑的 `markdwon` 文件。

现在我们新建一个 `HelloWorld.md` 并编辑为：

````markdown
# Hello World

访问链接安装适合自己机器的 .NET 6 环境: https://docs.microsoft.com/zh-cn/dotnet/core/install/

运行下面的命令创建项目，编写第1个.NET 6 C# 程序:

```bash
dotnet new console --output sample1
dotnet run --project sample1
```

以下程序中，不能正确输出`"Hello,World!"`内容的是：

## 答案

```csharp
var str1 = "Hello,";
var str2 = "World!";
Console.WriteLine("str1"+"str2");
```

## 选项

### A

```csharp
var str1 = "Hello,";
var str2 = "World!";
Console.WriteLine(str1+str2);
```

### B

```csharp
Console.WriteLine("Hello, World!");
```

### C

```csharp
var str = "Hello," + "World!"
Console.WriteLine(str);
```
````

这是一个最基本的习题结构，它包含标题、答案、选项，注意这几个一级和二级标题必须填写正确，解释器会读取这几个标题。而选项的标题会被直接忽略掉，在
最终生成的习题中不包含选项的三级标题，所以这个标题可以用来标注一些编辑信息，例如“使用 var 关键字”，“两个字符串拼接”等等。

## 可选的习题源代码项目

编辑习题中，为了测试方便，可以直接在3级知识节点目录下创建对应的习题代码子目录



## 技能树合成

在根目录下执行 `python main.py` 会合成技能树文件，合成的技能树文件: `data/tree.json`

* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
