# Run docker: 拉取镜像并运行

上一节创建了一个Python Flask 服务git仓库，然后为它配置了一个Dockerfile，最后构建了镜像并推送到Docker Hub。

现在，可以从 Docker Hub 拉取该镜像并运行。

首先，拉取镜像：

```bash
docker pull fanfeilong/cloud_native_hello_py
```

![](./docker_pull.jpg)

其次，运行容器：

```bash
docker run -p 1024:1024 -it fanfeilong/cloud_native_hello_py
```

这个命令没有指定容器启动后运行的命令，因此容器启动后会执行镜像制作时Dockerfile里指定的CMD命令，可以看到容器启动后执行了Python程序，容器服务在1024端口监听HTTP请求，因为 docker run 配置了参数`-p 1024:1024`，这里把主机的1024端口映射到了容器里的1024端口。

![](./run-with-port-map.jpg)

现在，在浏览器里测试下请求：

![](./test-request.jpg)

请求成功，输出了"Hello World!"，到这里你就成功学会了容器镜像制作、发布、拉取和运行一条龙服务。

以下描述错误的是？

## 答案

容器的端口映射，主机端口和容器内映射端口必须一样

## 选项

### A

容器的端口映射参数`-p`可以将主机端口转发给映射的容器内端口

### B

容器启动时如果没有指定执行的程序，就会执行在Dockerfile里使用CMD键配置的启动程序

### C

可以从 DockerHub拉取自己推送上去的镜像
